// Copyright 2014 Google Inc. All Rights Reserved.

#include "PhoneStatusEndpoint.h"

void PhoneStatusEndpoint::addDiscoveryInfo(ServiceDiscoveryResponse* sdr) {
    Service* service = sdr->add_services();
    service->set_id(id());
    service->mutable_phone_status_service();
}

int PhoneStatusEndpoint::routeMessage(
        uint8_t channelId, uint16_t type, const shared_ptr<IoBuffer>& msg) {
    int ret = STATUS_UNEXPECTED_MESSAGE;
    uint8_t* ptr = (uint8_t*)msg->raw() + sizeof(uint16_t);
    size_t len = msg->size() - sizeof(uint16_t);

    switch (type) {
        case PHONE_STATUS: {
            PhoneStatus status;
            if (PARSE_PROTO(status, ptr, len)) {
                handlePhoneStatus(status);
                ret = STATUS_SUCCESS;
            }
            break;
        }
    }
    return ret;
}

int PhoneStatusEndpoint::reportAction(
    const string& caller_number, const string& caller_id, uint32_t action) {
    if (InstrumentClusterInput::InstrumentClusterAction_IsValid(action)) {
      PhoneStatusInput input;
      if (!caller_number.empty()) {
          input.set_caller_number(caller_number);
      }
      if (!caller_id.empty()) {
          input.set_caller_id(caller_id);
      }
      input.mutable_input()->set_action((InstrumentClusterInput_InstrumentClusterAction)action);
      IoBuffer buf;
      mRouter->marshallProto(PHONE_STATUS_INPUT, input, &buf);
      queueOutgoing(buf.raw(), buf.size());
      return STATUS_SUCCESS;
    }
    return STATUS_INVALID_INPUT;
}

void PhoneStatusEndpoint::handlePhoneStatus(const PhoneStatus &status) {
    if (mCallbacks != NULL) {
        PhoneStatusStruct status_struct;
        status_struct.calls = new Call[status.calls_size()];
        status_struct.num_calls = status.calls_size();
        for (int i = 0; i < status.calls_size(); ++i) {
            Call& call_struct = status_struct.calls[i];
            const PhoneStatus_Call& call = status.calls(i);
            call_struct.state = call.phone_state();
            call_struct.call_duration_seconds = call.call_duration_seconds();
            if (call.has_caller_number()) {
              call_struct.caller_number = call.caller_number();
            }
            if (call.has_caller_id()) {
              call_struct.caller_id = call.caller_id();
            }
            if (call.has_caller_number_type()) {
                call_struct.caller_number_type = call.caller_number_type();
            }
            if (call.has_caller_thumbnail()) {
                call_struct.caller_thumbnail = call.caller_thumbnail();
            }
        }
        if (status.has_signal_strength()) {
            status_struct.signal_strength = status.signal_strength();
        }
        mCallbacks->phoneStatusCallback(status_struct);
    }
}
